<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSalaryGradeInfoToPayrollEmployees extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('payroll_employees', function (Blueprint $table) {
            $table->integer('salary_grade')->after('net_pay')->nullable();
            $table->integer('salary_step')->after('salary_grade')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('payroll_employees', function (Blueprint $table) {
            $table->dropColumn(['salary_grade', 'salary_step']);
        });
    }
}
