<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnTimekeepingDeductions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('timekeeping_deductions', function (Blueprint $table) {
            $table->decimal('points', 8, 3)->change();
            $table->double('basic_pay_deduction')->nullable()->after('points');
            $table->double('pera_deduction')->nullable()->after('basic_pay_deduction');
            $table->double('leave_balance_remaining')->nullable()->after('pera_deduction');
            $table->double('leave_balance_deduction')->nullable()->after('leave_balance_remaining');
            $table->double('leave_balance_result')->nullable()->after('leave_balance_deduction');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('timekeeping_deductions', function (Blueprint $table) {
            $table->decimal('points', 8, 2)->change();
            $table->dropColumn(['basic_pay_deduction', 'pera_deduction', 'leave_balance_remaining', 'leave_balance_deduction', 'leave_balance_result']);
        });
    }
}
