<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollPayBreakdownsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('payroll_pay_breakdowns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('earning_deduction_id')->nullable();
            $table->date('date')->nullable();
            $table->double('pay_hours')->nullable();
            $table->integer('working_hours')->nullable();
            $table->integer('working_days')->nullable();
            $table->double('hourly_rate')->nullable();
            $table->double('percentage')->nullable();
            $table->double('resulting_amount')->nullable();
            $table->string('remarks')->nullable();
            $table->timestamps();
            $table->foreign('earning_deduction_id')->references('id')->on(env('ADG_DB_DATABASE').'.payroll_earning_deductions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('payroll_pay_breakdowns');
    }
}
