<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollAllowanceBreakdownsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('payroll_allowance_breakdowns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('earning_deduction_id')->nullable();
            $table->integer('lwop_type')->nullable()->comment('1 = absent');
            $table->date('date')->nullable();
            $table->integer('minutes')->nullable();
            $table->double('gross_amount')->nullable();
            $table->double('deducted_amount')->nullable();
            $table->double('resulting_amount')->nullable();
            $table->string('remarks')->nullable();
            $table->timestamps();
            $table->foreign('earning_deduction_id')->references('id')->on(env('ADG_DB_DATABASE').'.payroll_earning_deductions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('payroll_allowance_breakdowns');
    }
}
