<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSuccessorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('successors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('critical_position_id');
            $table->unsignedBigInteger('successor_id');
            $table->integer('status')->default(1)->comment('1 = successor, 2 = promoted');
            $table->timestamps();
            $table->foreign('critical_position_id')->references('id')->on(env('ADG_DB_DATABASE') . '.critical_positions');
            $table->foreign('successor_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('successors');
    }
}
