<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCriticalPositionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('critical_positions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('item_code_id');
            $table->unsignedBigInteger('current_incumbent_id')->nullable();
            $table->unsignedBigInteger('reason_for_replacement_id')->nullable();
            $table->date('vacancy_start')->nullable();
            $table->integer('status')->default(1)->comment('1 = have no promotion, 2 = have promotion');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('current_incumbent_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('deleted_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('reason_for_replacement_id')->references('id')->on(env('ADG_DB_DATABASE') . '.remarks');
            $table->foreign('item_code_id')->references('id')->on(env('HRJP_DB_DATABASE').'.item_codes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('critical_positions');
    }
}
