<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMentorshipAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('mentorship_attachments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('mentorship_id');
            $table->text('file_name');
            $table->text('file_path');
            $table->foreign('mentorship_id')->references('id')->on(env('ADG_DB_DATABASE') . '.mentorships');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('mentorship_attachments');
    }
}
