<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnEmployeeType extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_types', function (Blueprint $table) {
            $table->integer('type')->nullable()->after('description')->default(1)->comment('1 = Plantilla, 2 = COS');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_types', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
}
