<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateColumnsInEmployeeEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_evaluation', function (Blueprint $table) {
            $table->timestamp('submitted_date')->nullable()->after('status');
            $table->dropColumn('review_dt');
            $table->timestamp('review_date')->nullable()->after('submitted_date');
            $table->timestamp('approved_date')->nullable()->after('review_date');
            $table->integer('status')->comment('0 = in progress, 1 = submitted, 2 = for approval, 3 = approved, 4 = acknowledged, 5 = declined')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_evaluation', function (Blueprint $table) {
            $table->dropColumn('submitted_date');
            $table->date('review_dt')->after('status');
            $table->dropColumn('review_date');
            $table->dropColumn('approved_date');
            $table->integer('status')->comment('0 = in progress, 1 = submitted, 2 = for approval, 3 = approved, 4 = acknowledged')->change();
        });
    }
}
