<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMetricEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('metric_evaluation', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('performance_eval_id');
            $table->unsignedBigInteger('eval_classification_id');
            $table->text('description')->nullable();
            $table->text('success_q')->nullable();
            $table->text('success_e')->nullable();
            $table->text('success_t')->nullable();
            $table->text('actual_q')->nullable();
            $table->text('actual_e')->nullable();
            $table->text('actual_t')->nullable();
            $table->integer('rate_q')->nullable();
            $table->integer('rate_e')->nullable();
            $table->integer('rate_t')->nullable();
            $table->float('average')->nullable();
            $table->text('remarks')->nullable();
            $table->timestamps();

            $table->foreign('performance_eval_id')->references('id')->on(env('ADG_DB_DATABASE'). '.performance_evaluation');
            $table->foreign('eval_classification_id')->references('id')->on(env('ADG_DB_DATABASE'). '.evaluation_classifications');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('metric_evaluation');
    }
}
