<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('employee_evaluation', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id');
            $table->unsignedBigInteger('evaluator');
            $table->unsignedBigInteger('approver');
            $table->unsignedBigInteger('review_form_type');
            $table->date('start_date');
            $table->date('end_date');
            $table->float('q_average')->nullable();
            $table->float('e_average')->nullable();
            $table->float('t_average')->nullable();
            $table->float('overall_rate')->nullable();
            $table->integer('status')->comment('0 = in progress, 1 = submitted, 2 = for approval, 3 = approved, 4 = acknowledged');
            $table->date('review_dt')->nullable();
            $table->text('comment_recommendation')->nullable();
            $table->foreign('employee_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('evaluator')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('approver')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('review_form_type')->references('id')->on(env('ADG_DB_DATABASE').'.pcr_form_types');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('employee_evaluation');
    }
}
