<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePCRFormPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('pcr_form_permissions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('pcr_form_type_id');
            $table->string('name');
            $table->integer('minimum_salary_grade');
            $table->integer('maximum_salary_grade');
            $table->integer('permission_type')->comment('1 = create, 2 = view');
            $table->timestamps();

            $table->foreign('pcr_form_type_id')->references('id')->on(env('ADG_DB_DATABASE') . '.pcr_form_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('pcr_form_permissions');
    }
}
