<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveAllowancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('leave_allowances', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_id');
            $table->unsignedBigInteger('allowance_id');
            $table->integer('type')->comment('1 = paid, 2 = not paid');
            $table->foreign('leave_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leaves');
            $table->foreign('allowance_id')->references('id')->on(env('ADG_DB_DATABASE') . '.allowances');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('leave_allowances');
    }
}
