<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeColumnToLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('leaves', function (Blueprint $table) {
            $table->dropForeign('leaves_leave_subtype_id_foreign');
            $table->dropIndex('leaves_leave_subtype_id_foreign');
            $table->renameColumn('leave_subtype_id', 'leave_type_id');
            $table->foreign('leave_type_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_types');

            $table->dropColumn('specified_details');
            $table->dropColumn('save_status');
            $table->text('remarks')->nullable()->after('reason_purpose');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('leaves', function (Blueprint $table) {
            $table->dropForeign('leaves_leave_type_id_foreign');
            $table->dropIndex('leaves_leave_type_id_foreign');
            $table->renameColumn('leave_type_id', 'leave_subtype_id');
            $table->foreign('leave_subtype_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_subtypes');

            $table->text('specified_details');
            $table->integer('save_status')->nullable();
            $table->dropColumn('remarks');
        });
    }
}
