<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnToPayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('payrolls', function (Blueprint $table) {
            $table->integer('payroll_employee_generated_count')->nullable()->after('remarks')->default(0);
            $table->integer('payroll_employee_total_count')->nullable()->after('payroll_employee_generated_count')->default(0);
            $table->integer('status')->comment('1 = For Review, 2 = Disbursed, 3 = Void, 4 = Ongoing, 5 = Pending')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('payrolls', function (Blueprint $table) {
            $table->dropColumn(['payroll_employee_generated_count', 'payroll_employee_total_count']);
            $table->integer('status')->comment('1 = For Review, 2 = Disbursed, 3 = Void')->change();
        });
    }
}
