<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnAttendance extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('attendances', function(Blueprint $table) {
            $table->string('device_in')->nullable(true)->after('break_out');
            $table->string('device_out')->nullable(true)->after('device_in');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('attendances', function(Blueprint $table) {
            $table->dropColumn('device_in');
            $table->dropColumn('device_out');
        });
    }
}
