<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeColumnBiometricDevice extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('biometric_devices', function(Blueprint $table) {
            $table->dropForeign(['department_id']);
            $table->dropIndex('biometric_devices_department_id_foreign');

            $table->dropForeign(['division_id']);
            $table->dropIndex('biometric_devices_division_id_foreign');

            $table->dropColumn('department_id');
            $table->dropColumn('division_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('biometric_devices', function(Blueprint $table) {
            $table->unsignedBigInteger('department_id')->nullable(true)->after('port');
            $table->unsignedBigInteger('division_id')->nullable(true)->after('department_id');

            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE') . '.departments');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE') . '.divisions');
        });
    }
}
