<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnsUserHasLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('user_has_loans', function(Blueprint $table) {
            $table->integer('terms_of_payment')->nullable()->change();
            $table->double('outstanding_balance')->nullable()->after('purpose_of_loan');
        });
        Schema::connection(env('ADG_DB_CONNECTION'))->table('user_has_loans', function(Blueprint $table) {
            $table->renameColumn('terms_of_payment', 'number_of_payments');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('user_has_loans', function(Blueprint $table) {
            $table->string('number_of_payments')->nullable(false)->change();
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('user_has_loans', function(Blueprint $table) {
            $table->dropColumn('outstanding_balance');
            $table->renameColumn('number_of_payments', 'terms_of_payment');
        });
    }
}
