<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoanPaymentHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('loan_payment_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_earning_deduction_id');
            $table->unsignedBigInteger('user_has_loan_id');
            $table->integer('status')->comment('0 = Pending, 1 = Approved, 2 = Voided');
            $table->integer('remaining_months');
            $table->double('amortization_amount');
            $table->double('outstanding_balance');
            $table->foreign('payroll_earning_deduction_id')->references('id')->on(env('ADG_DB_DATABASE') . '.payroll_earning_deductions');
            $table->foreign('user_has_loan_id')->references('id')->on(env('ADG_DB_DATABASE') . '.user_has_loans');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('loan_payment_histories');
    }
}
