<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollEmployeeLeaveHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('payroll_employee_leave_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_employee_id')->nullable();
            $table->unsignedBigInteger('leave_credit_history_id')->nullable();
            $table->foreign('payroll_employee_id')->references('id')->on(env('ADG_DB_DATABASE') . '.payroll_employees');
            $table->foreign('leave_credit_history_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_credit_histories');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('payroll_employee_leave_histories');
    }
}
