<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveCreditHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_credit_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('leave_type_id');
            $table->decimal('credits', 8, 3);
            $table->decimal('resulting_balance', 8, 3);
            $table->integer('leave_adjustment_type')->comment('1 = earned, 2 = deducted, 3 = reset');
            $table->text('remarks');
            $table->date('period');
            $table->unsignedBigInteger('created_by');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('leave_type_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_types');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_credit_histories');
    }
}
