<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveEligibleGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_eligible_groups', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_type_id');
            $table->unsignedBigInteger('group_id');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->foreign('group_id')->references('id')->on(env('DB_DATABASE') . '.roles');
            $table->foreign('leave_type_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_eligible_groups');
    }
}
