<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyLeaveTypeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('leave_types', function (Blueprint $table) {
            $table->decimal('initial_points')->after('description')->nullable();
            $table->boolean('file_attachment')->after('initial_points')->nullable();
            $table->decimal('default_increase')->nullable()->change();
            $table->integer('increase_type')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('leave_types', function (Blueprint $table) {
            $table->dropColumn(['initial_points']);
            $table->dropColumn(['file_attachment']);
            $table->decimal('default_increase')->nullable(false)->change();
            $table->integer('increase_type')->nullable(false)->change();
        });
    }
}
