<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnOvertimeAccomplishmentReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('overtime_accomplishment_reports', function(Blueprint $table) {
            $table->integer('status')->after('actual_overtime_work')->default(3)->comment('1 - Approved, 2 - Disapproved, 3 - For Review');
            $table->string('remarks')->after('status')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('overtime_accomplishment_reports', function(Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('remarks');
        });
    }
}
