<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnCorporationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('corporations', function(Blueprint $table){
            $table->string('office_code')->nullable()->after('name');
            $table->string('employer_id')->nullable()->after('office_code');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('corporations', function(Blueprint $table){
            $table->dropColumn('office_code');
            $table->dropColumn('employer_id');
        });
    }
}
