<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeColumnNullableBiometricDevices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('biometric_devices', function (Blueprint $table) {
            $table->unsignedBigInteger('department_id')->nullable()->references('id')->on(env('ADG_DB_DATABASE') . '.departments')->change();
            $table->unsignedBigInteger('division_id')->nullable()->references('id')->on(env('ADG_DB_DATABASE') . '.divisions')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::connection('adg_db')->table('biometric_devices', function (Blueprint $table) {
            $table->dropForeign(['department_id']);
            $table->dropForeign(['division_id']);
            $table->dropIndex('biometric_devices_department_id_foreign');
            $table->dropIndex('biometric_devices_division_id_foreign');
        });
        Schema::connection('adg_db')->table('biometric_devices', function (Blueprint $table) {
            $table->unsignedBigInteger('department_id')->nullable(false)->change();
            $table->unsignedBigInteger('division_id')->nullable(false)->change();
        });
        Schema::enableForeignKeyConstraints();
    }
}
