<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterEmployeeRequiredHours extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_employee_required_hours', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('roster_partition_id')->nullable();
            $table->unsignedBigInteger('roster_employee_id')->nullable();
            $table->integer('required_hours')->nullable()->default(0);
            $table->softDeletes();
            $table->timestamps();
            
            $table->foreign('roster_partition_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_partitions');
            $table->foreign('roster_employee_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employees_per_groups');
        });

        Schema::connection('adg_db')->create('roster_head_required_hours', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('roster_partition_id')->nullalbe();
            $table->unsignedBigInteger('roster_id')->nullable();
            $table->integer('required_hours')->nullable()->default(0);
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('roster_partition_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_partitions');
            $table->foreign('roster_id')->references('id')->on(env('ADG_DB_DATABASE') . '.rosters');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_employee_required_hours');
        Schema::connection('adg_db')->dropIfExists('roster_head_required_hours');
    }
}
