<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToHolidaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::disableForeignKeyConstraints();

        Schema::connection('adg_db')->table('holidays', function (Blueprint $table) {
            $table->time('time_effectivity')->nullable()->after('holiday_type_id');
            $table->unsignedBigInteger('branch_id')->after('time_effectivity');


            $table->foreign('branch_id')->references('id')->on(env('ADG_DB_DATABASE') . '.branches');
        });

        Schema::enableForeignKeyConstraints();

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();

        Schema::connection('adg_db')->table('holidays', function (Blueprint $table) {
            $table->dropForeign(['branch_id']);
            $table->dropColumn(['time_effectivity', 'branch_id']);
        });

        Schema::enableForeignKeyConstraints();
    }
}
