<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateSalaryStandardizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('salary_standardizations', function(Blueprint $table){
            $table->unsignedBigInteger('employee_type_id')->nullable()->after('active_tranche');

            $table->foreign('employee_type_id')->references('id')->on(env('ADG_DB_DATABASE') . '.employee_types');
        });

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('salary_standardizations', function(Blueprint $table){
            $table->dropForeign(['employee_type_id']);
            $table->dropIndex('salary_standardizations_employee_type_id_foreign');
            $table->dropColumn('employee_type_id');
        });

        
    }
}
