<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeCasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('employee_cases', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->text('complaint_title');
            $table->date('date_of_complaint');
            $table->text('action_taken')->nullable();
            $table->date('date_of_action')->nullable();
            $table->integer('status')->comment('1 = pending, 2 = finished');
            $table->integer('created_by');
            $table->integer('updated_by');

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
     Schema::connection('adg_db')->dropIfExists('employee_cases');
    }
}
