<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateColumnsCtoApplications extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('cto_applications', function(Blueprint $table){
            $table->dropForeign(['cto_points_id']);
            $table->dropIndex('cto_applications_cto_points_id_foreign');
        });

        Schema::connection('adg_db')->table('cto_applications', function(Blueprint $table){
            $table->renameColumn('cto_points_id', 'coc_points_id');
        });

        Schema::connection('adg_db')->table('cto_applications', function(Blueprint $table){
            $table->foreign('coc_points_id')->references('id')->on(env('ADG_DB_DATABASE'). '.coc_points');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('cto_applications', function(Blueprint $table){
            $table->dropForeign(['coc_points_id']);
            $table->dropIndex('cto_applications_coc_points_id_foreign');
        });

        Schema::connection('adg_db')->table('cto_applications', function(Blueprint $table){
            $table->renameColumn('coc_points_id', 'cto_points_id');
        });

        Schema::connection('adg_db')->table('cto_applications', function(Blueprint $table){
            $table->foreign('cto_points_id')->references('id')->on(env('ADG_DB_DATABASE'). '.cto_points');
        });
    }
}
