<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOvertimeAccomplishmentReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('overtime_accomplishment_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('overtime_id');
            $table->decimal('mh_rendered');
            $table->longText('actual_output');
            $table->string('actual_overtime_work');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('overtime_id')->references('id')->on(env('ADG_DB_DATABASE'). '.user_overtimes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('overtime_accomplishment_reports');
    }
}
