<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterHeadEmployeeShifts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        schema::connection('adg_db')->create('roster_head_employee_shifts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('roster_id');
            $table->unsignedBigInteger('roster_day_id')->nullable();
            $table->unsignedBigInteger('shift_id')->nullable();
            $table->unsignedBigInteger('roster_legend_id')->nullable();
            $table->string('remarks')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('roster_legend_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_legends');
            $table->foreign('roster_id')->references('id')->on(env('ADG_DB_DATABASE') . '.rosters');
            $table->foreign('roster_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_days');
            $table->foreign('shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_head_employee_shifts');
    }
}
