<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeForeignColumnInRosterDayEmployeeShifts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->dropForeign(['roster_employees_per_group_id']);
            $table->dropIndex('roster_day_employee_shifts_roster_employees_per_group_id_foreign');
        });

        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->foreign('roster_employees_per_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employees_per_groups');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {   
        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->dropForeign(['roster_employees_per_group_id']);
            $table->dropIndex('roster_day_employee_shifts_roster_employees_per_group_id_foreign');
        });

        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->foreign('roster_employees_per_group_id')->references('user_id')->on(env('ADG_DB_DATABASE') . '.roster_employees_per_groups');
        });
    }
}
