<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeColumnsToNullableInRosterDayEmployeeShift extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->unsignedBigInteger('shift_id')->nullable()->change();
            $table->unsignedBigInteger('roster_legend_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->unsignedBigInteger('shift_id')->nullable(false)->change();
            $table->unsignedBigInteger('roster_legend_id')->nullable(false)->change();
        });
    }
}
