<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class MoveShiftColumnInRosterEmployeeGroups extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_employee_group_shifts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('shift_id')->nullable();
            $table->unsignedBigInteger('roster_employee_group_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('roster_employee_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employee_groups');
            $table->foreign('shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');

        });

        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->dropForeign(['roster_employee_group_id']);
            $table->dropIndex('roster_staff_per_days_roster_employee_group_id_foreign');
            $table->dropForeign(['shift_id']);
            $table->dropIndex('roster_staff_per_days_shift_id_foreign');
            $table->renameColumn('shift_id', 'roster_employee_group_shift_id');
            $table->dropColumn('roster_employee_group_id');
        });

        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->foreign('roster_employee_group_shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employee_group_shifts');
        });

        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            $table->dropForeign(['morning_shift_primary']);
            $table->dropIndex('roster_employee_groups_morning_shift_primary_foreign');
            $table->dropForeign(['morning_shift_secondary']);
            $table->dropIndex('roster_employee_groups_morning_shift_secondary_foreign');
            $table->dropForeign(['night_shift_primary']);
            $table->dropIndex('roster_employee_groups_night_shift_primary_foreign');
            $table->dropForeign(['night_shift_secondary']);
            $table->dropIndex('roster_employee_groups_night_shift_secondary_foreign');

            $table->dropColumn('morning_shift_primary');
            $table->dropColumn('night_shift_primary');
            $table->dropColumn('morning_shift_secondary');
            $table->dropColumn('night_shift_secondary');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {   
        Schema::connection('adg_db')->table('roster_employee_group_shifts', function (Blueprint $table){
            $table->dropForeign(['shift_id']);
            $table->dropIndex('roster_employee_group_shifts_shift_id_foreign');
            $table->dropForeign(['roster_employee_group_id']);
            $table->dropIndex('roster_employee_group_shifts_roster_employee_group_id_foreign');
        });
        Schema::connection('adg_db')->dropIfExists('roster_employee_group_shifts');

        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->unsignedBigInteger('roster_employee_group_id')->after('id');
            $table->dropForeign(['roster_employee_group_shift_id']);
            $table->dropIndex('roster_staff_per_days_roster_employee_group_shift_id_foreign');
            $table->renameColumn('roster_employee_group_shift_id','shift_id');
        });

        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->foreign('roster_employee_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employee_groups');
            $table->foreign('shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
        });

        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            
            $table->unsignedBigInteger('morning_shift_primary')->nullable();
            $table->unsignedBigInteger('morning_shift_secondary')->nullable();
            $table->unsignedBigInteger('night_shift_primary')->nullable();
            $table->unsignedBigInteger('night_shift_secondary')->nullable();

        });
        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {

            $table->BigInteger('morning_shift_primary')->unsigned()->nullable()->change();
            $table->foreign('morning_shift_primary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->BigInteger('morning_shift_secondary')->unsigned()->nullable()->change();
            $table->foreign('morning_shift_secondary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->BigInteger('night_shift_primary')->unsigned()->nullable()->change();
            $table->foreign('night_shift_primary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->BigInteger('night_shift_secondary')->unsigned()->nullable()->change();
            $table->foreign('night_shift_secondary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');    

        });
    }
}
