<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnRosterRescheduleRequestDates extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('roster_reschedule_request_dates', function(Blueprint $table) {
            $table->unsignedBigInteger('old_roster_day_id')->nullable()->after('old_shift');
            $table->unsignedBigInteger('old_shift')->nullable()->change();
            $table->renameColumn('old_shift', 'old_shift_id');
        });

        Schema::connection('adg_db')->table('roster_reschedule_request_dates', function(Blueprint $table) {
            $table->foreign('old_shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->foreign('old_roster_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_days');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('roster_reschedule_request_dates', function(Blueprint $table) {
            $table->dropForeign(['old_shift_id']);
            $table->dropIndex('roster_reschedule_request_dates_old_shift_id_foreign');
            $table->dropForeign(['old_roster_day_id']);
            $table->dropIndex('roster_reschedule_request_dates_old_roster_day_id_foreign');
        });

        Schema::connection('adg_db')->table('roster_reschedule_request_dates', function(Blueprint $table) {
            $table->dropColumn('old_roster_day_id');
            $table->renameColumn('old_shift_id', 'old_shift');
        });
    }
}
