<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnOnRosterStaffPerDay extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->unsignedBigInteger('shift_id')->after('roster_day_id');
        });

        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->foreign('shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->dropForeign(['shift_id']);
            $table->dropIndex('roster_staff_per_days_shift_id_foreign');
        });

        Schema::connection('adg_db')->table('roster_staff_per_days', function (Blueprint $table) {
            $table->dropColumn('shift_id');
        });
    }
}
