<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeColumnRosterDayEmployeeShifts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropIndex('roster_day_employee_shifts_user_id_foreign');
            $table->renameColumn('user_id', 'roster_employees_per_group_id');
            $table->string('remarks')->after('roster_legend_id')->nullable();
        });

        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->foreign('roster_employees_per_group_id')->references('user_id')->on(env('ADG_DB_DATABASE') . '.roster_employees_per_groups');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->dropForeign(['roster_employees_per_group_id']);
            $table->dropIndex('roster_day_employee_shifts_roster_employees_per_group_id_foreign');
        });

        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->renameColumn('roster_employees_per_group_id', 'user_id');
            $table->dropIfExists('remarks');
        });

        Schema::connection('adg_db')->table('roster_day_employee_shifts', function (Blueprint $table) {
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }
}
