<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterEmployeesPerGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_employees_per_groups', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('roster_employee_group_id');
            $table->unsignedBigInteger('roster_day_employee_shift_id')->nullable();

            $table->softDeletes();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('roster_employee_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employee_groups');
            $table->foreign('roster_day_employee_shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_day_employee_shifts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_employees_per_groups');
    }
}
