<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterStaffPerDay extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_staff_per_days', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger(('roster_employee_group_id'));
            $table->unsignedBigInteger('roster_day_id');
            $table->integer('number_of_staff');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('roster_employee_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employee_groups');
            $table->foreign('roster_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_days');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_staff_per_days');
    }
}
