<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeColumnRosterEmployeeGroup extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            $table->renameColumn('group_name', 'group_id');
            $table->renameColumn('mornint_shift_primary', 'morning_shift_primary');
        });

        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            $table->BigInteger('group_id')->unsigned()->change();
            $table->foreign('group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_groups');
            $table->BigInteger('morning_shift_primary')->unsigned()->nullable()->change();
            $table->foreign('morning_shift_primary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->BigInteger('morning_shift_secondary')->unsigned()->nullable()->change();
            $table->foreign('morning_shift_secondary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->BigInteger('night_shift_primary')->unsigned()->nullable()->change();
            $table->foreign('night_shift_primary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->BigInteger('night_shift_secondary')->unsigned()->nullable()->change();
            $table->foreign('night_shift_secondary')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
           
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            $table->dropForeign(['morning_shift_primary']);
            $table->dropIndex('roster_employee_groups_morning_shift_primary_foreign');
            $table->dropForeign(['morning_shift_secondary']);
            $table->dropIndex('roster_employee_groups_morning_shift_secondary_foreign');
            $table->dropForeign(['night_shift_primary']);
            $table->dropIndex('roster_employee_groups_night_shift_primary_foreign');
            $table->dropForeign(['night_shift_secondary']);
            $table->dropIndex('roster_employee_groups_night_shift_secondary_foreign');
            $table->dropForeign(['group_id']);
            $table->dropIndex('roster_employee_groups_group_id_foreign');
        });

        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            $table->renameColumn('group_id', 'group_name');
            $table->renameColumn('morning_shift_primary','mornint_shift_primary');
        });

        Schema::connection('adg_db')->table('roster_employee_groups', function (Blueprint $table) {
            $table->string('group_name')->change();
        });
    }
}
