<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnsShifts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('shifts', function (Blueprint $table) {
            $table->time('shift_in')->nullable()->after('description');
            $table->time('shift_out')->nullable()->after('shift_in');
            $table->time('break_in')->nullable()->after('shift_out');
            $table->time('break_out')->nullable()->after('break_in');
            $table->decimal('work_hours')->nullable()->after('break_out');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('shifts', function (Blueprint $table) {
            $table->dropColumn(['shift_in', 'shift_out', 'break_in', 'break_out', 'work_hours']);
        });
    }
}
