<?php

use App\Enums\OvertimePurpose;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnUserOvertimes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('user_overtimes', function (Blueprint $table) {
            $table->decimal('est_quantity')->nullable()->after('total_no_of_hours');
            $table->renameColumn('total_no_of_hours', 'est_mh_needed');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('user_overtimes', function (Blueprint $table) {
            $table->dropColumn('est_quantity');
            $table->renameColumn('est_mh_needed', 'total_no_of_hours');
        });
    }
}
