<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCOCPointsEarningsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('coc_points_earnings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('coc_points_id');
            $table->date('period');
            $table->decimal('points');
            $table->string('remarks');
            $table->decimal('resulting_points');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('coc_points_id')->references('id')->on(env('ADG_DB_DATABASE').'.coc_points');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('coc_points_earnings');
    }
}
