<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCtoApplications extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('cto_applications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('cto_points_id');
            $table->decimal('points');
            $table->string('reason')->nullable();
            $table->date('start_date');
            $table->date('end_date');
            $table->integer('status')->comment('0 = Pending, 1 = Approved, 2 = Disapproved')->default(0);
            $table->string('remarks')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('cto_points_id')->references('id')->on(env('ADG_DB_DATABASE').'.cto_points');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('cto_applications');
    }
}
