<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateNewUpdatesPdsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('new_updates_pds', function(Blueprint $table){
            $table->integer('status')->comment('1 = approve, 2 = decline, 3 = on-hold')->default(3)->change();
            $table->string('reason')->nullable()->after('status');
            $table->text('file_attachment')->nullable()->after('reason');
            $table->integer('result_status')->nullable()->after('file_attachment')->comment('1 = read, 0 = unread')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('new_updates_pds', function (Blueprint $table) {
            $table->dropColumn('reason');
            $table->dropColumn('file_attachment');
            $table->dropColumn('result_status');
        });
    }
}
