<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnEmploymentStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('user_salaries', function (Blueprint $table) {
            $table->integer('status')->comment('0 = active, 1 = inactive')->default(0)->after('date_of_effectivity');
        });

        Schema::connection('adg_db')->table('designation_histories', function (Blueprint $table) {
            $table->integer('employment_status')->comment('0 = currently_employed, 1 = re-employed')->default(0)->after('status');
        });

        Schema::connection('hrjp_db')->table('position_histories', function (Blueprint $table) {
            $table->integer('employment_status')->comment('0 = currently employed, 1 = re-employed')->default(0)->after('position_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('user_salaries', function(Blueprint $table) {
            $table->dropColumn(['status']);
        });

        Schema::connection('adg_db')->table('designation_histories', function(Blueprint $table) {
            $table->dropColumn(['employment_status']);
        });

        Schema::connection('hrjp_db')->table('position_histories', function(Blueprint $table) {
            $table->dropColumn(['employment_status']);
        });
    }
}
