<?php

use App\Enums\OvertimePurpose;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOvertimeOption extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('user_overtimes', function(Blueprint $table){
            $table->tinyInteger('purpose')->comment('1 = for Compensatory Time-Off(CTO), 2 = For Pay')->default(OvertimePurpose::PAY);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('user_overtimes', function(Blueprint $table){
            $table->dropColumn(['purpose']);
        });
    }
}
