<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLongevityPaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('longevity_pays', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->date('date');
            $table->integer('number')->default(1);
            $table->double('latest_pay')->comment('Latest longevity of the current payroll generated')->default(0);
            $table->double('total_pay')->comment('Total of all longevity pays added from previous')->default(0);

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('longevity_pays');
    }
}
